package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.String20
import scala.jdk.CollectionConverters._
final case class VsamDetailAttributes(
    alternateKeys: Optional[Iterable[zio.aws.m2.model.AlternateKey]] =
      Optional.Absent,
    cacheAtStartup: Optional[Boolean] = Optional.Absent,
    compressed: Optional[Boolean] = Optional.Absent,
    encoding: Optional[String20] = Optional.Absent,
    primaryKey: Optional[zio.aws.m2.model.PrimaryKey] = Optional.Absent,
    recordFormat: Optional[String20] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.VsamDetailAttributes = {
    import VsamDetailAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.VsamDetailAttributes
      .builder()
      .optionallyWith(
        alternateKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternateKeys)
      .optionallyWith(cacheAtStartup.map(value => value: java.lang.Boolean))(
        _.cacheAtStartup
      )
      .optionallyWith(compressed.map(value => value: java.lang.Boolean))(
        _.compressed
      )
      .optionallyWith(
        encoding.map(value => String20.unwrap(value): java.lang.String)
      )(_.encoding)
      .optionallyWith(primaryKey.map(value => value.buildAwsValue()))(
        _.primaryKey
      )
      .optionallyWith(
        recordFormat.map(value => String20.unwrap(value): java.lang.String)
      )(_.recordFormat)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.VsamDetailAttributes.ReadOnly =
    zio.aws.m2.model.VsamDetailAttributes.wrap(buildAwsValue())
}
object VsamDetailAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.VsamDetailAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.VsamDetailAttributes =
      zio.aws.m2.model.VsamDetailAttributes(
        alternateKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheAtStartup.map(value => value),
        compressed.map(value => value),
        encoding.map(value => value),
        primaryKey.map(value => value.asEditable),
        recordFormat.map(value => value)
      )
    def alternateKeys: Optional[List[zio.aws.m2.model.AlternateKey.ReadOnly]]
    def cacheAtStartup: Optional[Boolean]
    def compressed: Optional[Boolean]
    def encoding: Optional[String20]
    def primaryKey: Optional[zio.aws.m2.model.PrimaryKey.ReadOnly]
    def recordFormat: Optional[String20]
    def getAlternateKeys
        : ZIO[Any, AwsError, List[zio.aws.m2.model.AlternateKey.ReadOnly]] =
      AwsError.unwrapOptionField("alternateKeys", alternateKeys)
    def getCacheAtStartup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheAtStartup", cacheAtStartup)
    def getCompressed: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("compressed", compressed)
    def getEncoding: ZIO[Any, AwsError, String20] =
      AwsError.unwrapOptionField("encoding", encoding)
    def getPrimaryKey
        : ZIO[Any, AwsError, zio.aws.m2.model.PrimaryKey.ReadOnly] =
      AwsError.unwrapOptionField("primaryKey", primaryKey)
    def getRecordFormat: ZIO[Any, AwsError, String20] =
      AwsError.unwrapOptionField("recordFormat", recordFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.VsamDetailAttributes
  ) extends zio.aws.m2.model.VsamDetailAttributes.ReadOnly {
    override val alternateKeys
        : Optional[List[zio.aws.m2.model.AlternateKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alternateKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.AlternateKey.wrap(item)
          }.toList
        )
    override val cacheAtStartup: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheAtStartup())
      .map(value => value: Boolean)
    override val compressed: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.compressed())
      .map(value => value: Boolean)
    override val encoding: Optional[String20] = zio.aws.core.internal
      .optionalFromNullable(impl.encoding())
      .map(value => zio.aws.m2.model.primitives.String20(value))
    override val primaryKey: Optional[zio.aws.m2.model.PrimaryKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryKey())
        .map(value => zio.aws.m2.model.PrimaryKey.wrap(value))
    override val recordFormat: Optional[String20] = zio.aws.core.internal
      .optionalFromNullable(impl.recordFormat())
      .map(value => zio.aws.m2.model.primitives.String20(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.VsamDetailAttributes
  ): zio.aws.m2.model.VsamDetailAttributes.ReadOnly = new Wrapper(impl)
}
