package zio.aws.m2.model
import zio.aws.m2.model.primitives.{EntityDescription, Version, Identifier}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationId: Identifier,
    currentApplicationVersion: Version,
    definition: Optional[zio.aws.m2.model.Definition] = Optional.Absent,
    description: Optional[EntityDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.UpdateApplicationRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .currentApplicationVersion(
        Version.unwrap(currentApplicationVersion): Integer
      )
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.m2.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.UpdateApplicationRequest =
      zio.aws.m2.model.UpdateApplicationRequest(
        applicationId,
        currentApplicationVersion,
        definition.map(value => value.asEditable),
        description.map(value => value)
      )
    def applicationId: Identifier
    def currentApplicationVersion: Version
    def definition: Optional[zio.aws.m2.model.Definition.ReadOnly]
    def description: Optional[EntityDescription]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getCurrentApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(currentApplicationVersion)
    def getDefinition
        : ZIO[Any, AwsError, zio.aws.m2.model.Definition.ReadOnly] =
      AwsError.unwrapOptionField("definition", definition)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.UpdateApplicationRequest
  ) extends zio.aws.m2.model.UpdateApplicationRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val currentApplicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.currentApplicationVersion())
    override val definition: Optional[zio.aws.m2.model.Definition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value => zio.aws.m2.model.Definition.wrap(value))
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.m2.model.primitives.EntityDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.UpdateApplicationRequest
  ): zio.aws.m2.model.UpdateApplicationRequest.ReadOnly = new Wrapper(impl)
}
