package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StorageConfiguration(
    efs: Optional[zio.aws.m2.model.EfsStorageConfiguration] = Optional.Absent,
    fsx: Optional[zio.aws.m2.model.FsxStorageConfiguration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.StorageConfiguration = {
    import StorageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.StorageConfiguration
      .builder()
      .optionallyWith(efs.map(value => value.buildAwsValue()))(_.efs)
      .optionallyWith(fsx.map(value => value.buildAwsValue()))(_.fsx)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.StorageConfiguration.ReadOnly =
    zio.aws.m2.model.StorageConfiguration.wrap(buildAwsValue())
}
object StorageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.StorageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.StorageConfiguration =
      zio.aws.m2.model.StorageConfiguration(
        efs.map(value => value.asEditable),
        fsx.map(value => value.asEditable)
      )
    def efs: Optional[zio.aws.m2.model.EfsStorageConfiguration.ReadOnly]
    def fsx: Optional[zio.aws.m2.model.FsxStorageConfiguration.ReadOnly]
    def getEfs: ZIO[
      Any,
      AwsError,
      zio.aws.m2.model.EfsStorageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("efs", efs)
    def getFsx: ZIO[
      Any,
      AwsError,
      zio.aws.m2.model.FsxStorageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("fsx", fsx)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.StorageConfiguration
  ) extends zio.aws.m2.model.StorageConfiguration.ReadOnly {
    override val efs
        : Optional[zio.aws.m2.model.EfsStorageConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.efs())
        .map(value => zio.aws.m2.model.EfsStorageConfiguration.wrap(value))
    override val fsx
        : Optional[zio.aws.m2.model.FsxStorageConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fsx())
        .map(value => zio.aws.m2.model.FsxStorageConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.StorageConfiguration
  ): zio.aws.m2.model.StorageConfiguration.ReadOnly = new Wrapper(impl)
}
