package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsResponse(
    environments: Iterable[zio.aws.m2.model.EnvironmentSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse
      .builder()
      .environments(environments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.m2.model.ListEnvironmentsResponse.wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListEnvironmentsResponse =
      zio.aws.m2.model.ListEnvironmentsResponse(
        environments.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def environments: List[zio.aws.m2.model.EnvironmentSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEnvironments: ZIO[Any, Nothing, List[
      zio.aws.m2.model.EnvironmentSummary.ReadOnly
    ]] = ZIO.succeed(environments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse
  ) extends zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly {
    override val environments
        : List[zio.aws.m2.model.EnvironmentSummary.ReadOnly] = impl
      .environments()
      .asScala
      .map { item =>
        zio.aws.m2.model.EnvironmentSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse
  ): zio.aws.m2.model.ListEnvironmentsResponse.ReadOnly = new Wrapper(impl)
}
