package zio.aws.m2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.CapacityValue
import scala.jdk.CollectionConverters._
final case class HighAvailabilityConfig(desiredCapacity: CapacityValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.HighAvailabilityConfig = {
    import HighAvailabilityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.HighAvailabilityConfig
      .builder()
      .desiredCapacity(CapacityValue.unwrap(desiredCapacity): Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.HighAvailabilityConfig.ReadOnly =
    zio.aws.m2.model.HighAvailabilityConfig.wrap(buildAwsValue())
}
object HighAvailabilityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.HighAvailabilityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.HighAvailabilityConfig =
      zio.aws.m2.model.HighAvailabilityConfig(desiredCapacity)
    def desiredCapacity: CapacityValue
    def getDesiredCapacity: ZIO[Any, Nothing, CapacityValue] =
      ZIO.succeed(desiredCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.HighAvailabilityConfig
  ) extends zio.aws.m2.model.HighAvailabilityConfig.ReadOnly {
    override val desiredCapacity: CapacityValue =
      zio.aws.m2.model.primitives.CapacityValue(impl.desiredCapacity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.HighAvailabilityConfig
  ): zio.aws.m2.model.HighAvailabilityConfig.ReadOnly = new Wrapper(impl)
}
