package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.String2000
import scala.jdk.CollectionConverters._
final case class ExternalLocation(
    s3Location: Optional[String2000] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ExternalLocation = {
    import ExternalLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ExternalLocation
      .builder()
      .optionallyWith(
        s3Location.map(value => String2000.unwrap(value): java.lang.String)
      )(_.s3Location)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ExternalLocation.ReadOnly =
    zio.aws.m2.model.ExternalLocation.wrap(buildAwsValue())
}
object ExternalLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ExternalLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ExternalLocation =
      zio.aws.m2.model.ExternalLocation(s3Location.map(value => value))
    def s3Location: Optional[String2000]
    def getS3Location: ZIO[Any, AwsError, String2000] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ExternalLocation
  ) extends zio.aws.m2.model.ExternalLocation.ReadOnly {
    override val s3Location: Optional[String2000] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Location())
      .map(value => zio.aws.m2.model.primitives.String2000(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ExternalLocation
  ): zio.aws.m2.model.ExternalLocation.ReadOnly = new Wrapper(impl)
}
