package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class DeleteApplicationRequest(applicationId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DeleteApplicationRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.m2.model.DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DeleteApplicationRequest =
      zio.aws.m2.model.DeleteApplicationRequest(applicationId)
    def applicationId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DeleteApplicationRequest
  ) extends zio.aws.m2.model.DeleteApplicationRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DeleteApplicationRequest
  ): zio.aws.m2.model.DeleteApplicationRequest.ReadOnly = new Wrapper(impl)
}
