package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.{String2000, StringFree65000}
import scala.jdk.CollectionConverters._
final case class Definition(
    content: Optional[StringFree65000] = Optional.Absent,
    s3Location: Optional[String2000] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.m2.model.Definition = {
    import Definition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.Definition
      .builder()
      .optionallyWith(
        content.map(value => StringFree65000.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        s3Location.map(value => String2000.unwrap(value): java.lang.String)
      )(_.s3Location)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.Definition.ReadOnly =
    zio.aws.m2.model.Definition.wrap(buildAwsValue())
}
object Definition {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.Definition] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.Definition = zio.aws.m2.model
      .Definition(content.map(value => value), s3Location.map(value => value))
    def content: Optional[StringFree65000]
    def s3Location: Optional[String2000]
    def getContent: ZIO[Any, AwsError, StringFree65000] =
      AwsError.unwrapOptionField("content", content)
    def getS3Location: ZIO[Any, AwsError, String2000] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.Definition
  ) extends zio.aws.m2.model.Definition.ReadOnly {
    override val content: Optional[StringFree65000] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.m2.model.primitives.StringFree65000(value))
    override val s3Location: Optional[String2000] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Location())
      .map(value => zio.aws.m2.model.primitives.String2000(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.Definition
  ): zio.aws.m2.model.Definition.ReadOnly = new Wrapper(impl)
}
