package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.String2000
import scala.jdk.CollectionConverters._
final case class DataSetImportConfig(
    dataSets: Optional[Iterable[zio.aws.m2.model.DataSetImportItem]] =
      Optional.Absent,
    s3Location: Optional[String2000] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DataSetImportConfig = {
    import DataSetImportConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DataSetImportConfig
      .builder()
      .optionallyWith(
        dataSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSets)
      .optionallyWith(
        s3Location.map(value => String2000.unwrap(value): java.lang.String)
      )(_.s3Location)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DataSetImportConfig.ReadOnly =
    zio.aws.m2.model.DataSetImportConfig.wrap(buildAwsValue())
}
object DataSetImportConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DataSetImportConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DataSetImportConfig =
      zio.aws.m2.model.DataSetImportConfig(
        dataSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        s3Location.map(value => value)
      )
    def dataSets: Optional[List[zio.aws.m2.model.DataSetImportItem.ReadOnly]]
    def s3Location: Optional[String2000]
    def getDataSets: ZIO[Any, AwsError, List[
      zio.aws.m2.model.DataSetImportItem.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSets", dataSets)
    def getS3Location: ZIO[Any, AwsError, String2000] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportConfig
  ) extends zio.aws.m2.model.DataSetImportConfig.ReadOnly {
    override val dataSets
        : Optional[List[zio.aws.m2.model.DataSetImportItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.DataSetImportItem.wrap(item)
          }.toList
        )
    override val s3Location: Optional[String2000] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Location())
      .map(value => zio.aws.m2.model.primitives.String2000(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportConfig
  ): zio.aws.m2.model.DataSetImportConfig.ReadOnly = new Wrapper(impl)
}
