package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataSet(
    datasetName: String,
    datasetOrg: zio.aws.m2.model.DatasetOrgAttributes,
    recordLength: zio.aws.m2.model.RecordLength,
    relativePath: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.m2.model.DataSet = {
    import DataSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DataSet
      .builder()
      .datasetName(datasetName: java.lang.String)
      .datasetOrg(datasetOrg.buildAwsValue())
      .recordLength(recordLength.buildAwsValue())
      .optionallyWith(relativePath.map(value => value: java.lang.String))(
        _.relativePath
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DataSet.ReadOnly =
    zio.aws.m2.model.DataSet.wrap(buildAwsValue())
}
object DataSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.DataSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DataSet = zio.aws.m2.model.DataSet(
      datasetName,
      datasetOrg.asEditable,
      recordLength.asEditable,
      relativePath.map(value => value),
      storageType.map(value => value)
    )
    def datasetName: String
    def datasetOrg: zio.aws.m2.model.DatasetOrgAttributes.ReadOnly
    def recordLength: zio.aws.m2.model.RecordLength.ReadOnly
    def relativePath: Optional[String]
    def storageType: Optional[String]
    def getDatasetName: ZIO[Any, Nothing, String] = ZIO.succeed(datasetName)
    def getDatasetOrg
        : ZIO[Any, Nothing, zio.aws.m2.model.DatasetOrgAttributes.ReadOnly] =
      ZIO.succeed(datasetOrg)
    def getRecordLength
        : ZIO[Any, Nothing, zio.aws.m2.model.RecordLength.ReadOnly] =
      ZIO.succeed(recordLength)
    def getRelativePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("relativePath", relativePath)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DataSet
  ) extends zio.aws.m2.model.DataSet.ReadOnly {
    override val datasetName: String = impl.datasetName(): String
    override val datasetOrg: zio.aws.m2.model.DatasetOrgAttributes.ReadOnly =
      zio.aws.m2.model.DatasetOrgAttributes.wrap(impl.datasetOrg())
    override val recordLength: zio.aws.m2.model.RecordLength.ReadOnly =
      zio.aws.m2.model.RecordLength.wrap(impl.recordLength())
    override val relativePath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.relativePath())
      .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DataSet
  ): zio.aws.m2.model.DataSet.ReadOnly = new Wrapper(impl)
}
