package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchJobDefinition(
    fileBatchJobDefinition: Optional[zio.aws.m2.model.FileBatchJobDefinition] =
      Optional.Absent,
    scriptBatchJobDefinition: Optional[
      zio.aws.m2.model.ScriptBatchJobDefinition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.BatchJobDefinition = {
    import BatchJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.BatchJobDefinition
      .builder()
      .optionallyWith(
        fileBatchJobDefinition.map(value => value.buildAwsValue())
      )(_.fileBatchJobDefinition)
      .optionallyWith(
        scriptBatchJobDefinition.map(value => value.buildAwsValue())
      )(_.scriptBatchJobDefinition)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.BatchJobDefinition.ReadOnly =
    zio.aws.m2.model.BatchJobDefinition.wrap(buildAwsValue())
}
object BatchJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.BatchJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.BatchJobDefinition =
      zio.aws.m2.model.BatchJobDefinition(
        fileBatchJobDefinition.map(value => value.asEditable),
        scriptBatchJobDefinition.map(value => value.asEditable)
      )
    def fileBatchJobDefinition
        : Optional[zio.aws.m2.model.FileBatchJobDefinition.ReadOnly]
    def scriptBatchJobDefinition
        : Optional[zio.aws.m2.model.ScriptBatchJobDefinition.ReadOnly]
    def getFileBatchJobDefinition
        : ZIO[Any, AwsError, zio.aws.m2.model.FileBatchJobDefinition.ReadOnly] =
      AwsError.unwrapOptionField(
        "fileBatchJobDefinition",
        fileBatchJobDefinition
      )
    def getScriptBatchJobDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.m2.model.ScriptBatchJobDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scriptBatchJobDefinition",
      scriptBatchJobDefinition
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.BatchJobDefinition
  ) extends zio.aws.m2.model.BatchJobDefinition.ReadOnly {
    override val fileBatchJobDefinition
        : Optional[zio.aws.m2.model.FileBatchJobDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileBatchJobDefinition())
        .map(value => zio.aws.m2.model.FileBatchJobDefinition.wrap(value))
    override val scriptBatchJobDefinition
        : Optional[zio.aws.m2.model.ScriptBatchJobDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scriptBatchJobDefinition())
        .map(value => zio.aws.m2.model.ScriptBatchJobDefinition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.BatchJobDefinition
  ): zio.aws.m2.model.BatchJobDefinition.ReadOnly = new Wrapper(impl)
}
