package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListEngineVersionsResponse(
    engineVersions: Iterable[zio.aws.m2.model.EngineVersionsSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse = {
    import ListEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse
      .builder()
      .engineVersions(engineVersions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly =
    zio.aws.m2.model.ListEngineVersionsResponse.wrap(buildAwsValue())
}
object ListEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListEngineVersionsResponse =
      zio.aws.m2.model.ListEngineVersionsResponse(
        engineVersions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def engineVersions: List[zio.aws.m2.model.EngineVersionsSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEngineVersions: ZIO[Any, Nothing, List[
      zio.aws.m2.model.EngineVersionsSummary.ReadOnly
    ]] = ZIO.succeed(engineVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse
  ) extends zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly {
    override val engineVersions
        : List[zio.aws.m2.model.EngineVersionsSummary.ReadOnly] = impl
      .engineVersions()
      .asScala
      .map { item =>
        zio.aws.m2.model.EngineVersionsSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse
  ): zio.aws.m2.model.ListEngineVersionsResponse.ReadOnly = new Wrapper(impl)
}
