package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class GetBatchJobExecutionRequest(
    applicationId: Identifier,
    executionId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetBatchJobExecutionRequest = {
    import GetBatchJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetBatchJobExecutionRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .executionId(Identifier.unwrap(executionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetBatchJobExecutionRequest.ReadOnly =
    zio.aws.m2.model.GetBatchJobExecutionRequest.wrap(buildAwsValue())
}
object GetBatchJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetBatchJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetBatchJobExecutionRequest =
      zio.aws.m2.model.GetBatchJobExecutionRequest(applicationId, executionId)
    def applicationId: Identifier
    def executionId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getExecutionId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(executionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetBatchJobExecutionRequest
  ) extends zio.aws.m2.model.GetBatchJobExecutionRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val executionId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.executionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetBatchJobExecutionRequest
  ): zio.aws.m2.model.GetBatchJobExecutionRequest.ReadOnly = new Wrapper(impl)
}
