package zio.aws.m2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.{Version, Identifier}
import scala.jdk.CollectionConverters._
final case class GetApplicationVersionRequest(
    applicationId: Identifier,
    applicationVersion: Version
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetApplicationVersionRequest = {
    import GetApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetApplicationVersionRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetApplicationVersionRequest.ReadOnly =
    zio.aws.m2.model.GetApplicationVersionRequest.wrap(buildAwsValue())
}
object GetApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetApplicationVersionRequest =
      zio.aws.m2.model
        .GetApplicationVersionRequest(applicationId, applicationVersion)
    def applicationId: Identifier
    def applicationVersion: Version
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationVersionRequest
  ) extends zio.aws.m2.model.GetApplicationVersionRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationVersionRequest
  ): zio.aws.m2.model.GetApplicationVersionRequest.ReadOnly = new Wrapper(impl)
}
