package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileBatchJobIdentifier(
    fileName: String,
    folderPath: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.FileBatchJobIdentifier = {
    import FileBatchJobIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.FileBatchJobIdentifier
      .builder()
      .fileName(fileName: java.lang.String)
      .optionallyWith(folderPath.map(value => value: java.lang.String))(
        _.folderPath
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.FileBatchJobIdentifier.ReadOnly =
    zio.aws.m2.model.FileBatchJobIdentifier.wrap(buildAwsValue())
}
object FileBatchJobIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.FileBatchJobIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.FileBatchJobIdentifier = zio.aws.m2.model
      .FileBatchJobIdentifier(fileName, folderPath.map(value => value))
    def fileName: String
    def folderPath: Optional[String]
    def getFileName: ZIO[Any, Nothing, String] = ZIO.succeed(fileName)
    def getFolderPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("folderPath", folderPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.FileBatchJobIdentifier
  ) extends zio.aws.m2.model.FileBatchJobIdentifier.ReadOnly {
    override val fileName: String = impl.fileName(): String
    override val folderPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.folderPath())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.FileBatchJobIdentifier
  ): zio.aws.m2.model.FileBatchJobIdentifier.ReadOnly = new Wrapper(impl)
}
