package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait EngineType {
  def unwrap: software.amazon.awssdk.services.m2.model.EngineType
}
object EngineType {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.EngineType
  ): zio.aws.m2.model.EngineType = value match {
    case software.amazon.awssdk.services.m2.model.EngineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.EngineType.MICROFOCUS =>
      val r = microfocus
      r
    case software.amazon.awssdk.services.m2.model.EngineType.BLUAGE =>
      val r = bluage
      r
  }
  case object unknownToSdkVersion extends zio.aws.m2.model.EngineType {
    override def unwrap: software.amazon.awssdk.services.m2.model.EngineType =
      software.amazon.awssdk.services.m2.model.EngineType.UNKNOWN_TO_SDK_VERSION
  }
  case object microfocus extends zio.aws.m2.model.EngineType {
    override def unwrap: software.amazon.awssdk.services.m2.model.EngineType =
      software.amazon.awssdk.services.m2.model.EngineType.MICROFOCUS
  }
  case object bluage extends zio.aws.m2.model.EngineType {
    override def unwrap: software.amazon.awssdk.services.m2.model.EngineType =
      software.amazon.awssdk.services.m2.model.EngineType.BLUAGE
  }
}
