package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListBatchJobDefinitionsResponse(
    batchJobDefinitions: Iterable[zio.aws.m2.model.BatchJobDefinition],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse = {
    import ListBatchJobDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse
      .builder()
      .batchJobDefinitions(batchJobDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListBatchJobDefinitionsResponse.ReadOnly =
    zio.aws.m2.model.ListBatchJobDefinitionsResponse.wrap(buildAwsValue())
}
object ListBatchJobDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListBatchJobDefinitionsResponse =
      zio.aws.m2.model.ListBatchJobDefinitionsResponse(
        batchJobDefinitions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def batchJobDefinitions: List[zio.aws.m2.model.BatchJobDefinition.ReadOnly]
    def nextToken: Optional[NextToken]
    def getBatchJobDefinitions: ZIO[Any, Nothing, List[
      zio.aws.m2.model.BatchJobDefinition.ReadOnly
    ]] = ZIO.succeed(batchJobDefinitions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse
  ) extends zio.aws.m2.model.ListBatchJobDefinitionsResponse.ReadOnly {
    override val batchJobDefinitions
        : List[zio.aws.m2.model.BatchJobDefinition.ReadOnly] = impl
      .batchJobDefinitions()
      .asScala
      .map { item =>
        zio.aws.m2.model.BatchJobDefinition.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse
  ): zio.aws.m2.model.ListBatchJobDefinitionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
