package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class GetDataSetImportTaskRequest(
    applicationId: Identifier,
    taskId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetDataSetImportTaskRequest = {
    import GetDataSetImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetDataSetImportTaskRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .taskId(Identifier.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetDataSetImportTaskRequest.ReadOnly =
    zio.aws.m2.model.GetDataSetImportTaskRequest.wrap(buildAwsValue())
}
object GetDataSetImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetDataSetImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetDataSetImportTaskRequest =
      zio.aws.m2.model.GetDataSetImportTaskRequest(applicationId, taskId)
    def applicationId: Identifier
    def taskId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getTaskId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetImportTaskRequest
  ) extends zio.aws.m2.model.GetDataSetImportTaskRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val taskId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetDataSetImportTaskRequest
  ): zio.aws.m2.model.GetDataSetImportTaskRequest.ReadOnly = new Wrapper(impl)
}
