package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetOrgAttributes(
    gdg: Optional[zio.aws.m2.model.GdgAttributes] = Optional.Absent,
    vsam: Optional[zio.aws.m2.model.VsamAttributes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DatasetOrgAttributes = {
    import DatasetOrgAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DatasetOrgAttributes
      .builder()
      .optionallyWith(gdg.map(value => value.buildAwsValue()))(_.gdg)
      .optionallyWith(vsam.map(value => value.buildAwsValue()))(_.vsam)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DatasetOrgAttributes.ReadOnly =
    zio.aws.m2.model.DatasetOrgAttributes.wrap(buildAwsValue())
}
object DatasetOrgAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DatasetOrgAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DatasetOrgAttributes =
      zio.aws.m2.model.DatasetOrgAttributes(
        gdg.map(value => value.asEditable),
        vsam.map(value => value.asEditable)
      )
    def gdg: Optional[zio.aws.m2.model.GdgAttributes.ReadOnly]
    def vsam: Optional[zio.aws.m2.model.VsamAttributes.ReadOnly]
    def getGdg: ZIO[Any, AwsError, zio.aws.m2.model.GdgAttributes.ReadOnly] =
      AwsError.unwrapOptionField("gdg", gdg)
    def getVsam: ZIO[Any, AwsError, zio.aws.m2.model.VsamAttributes.ReadOnly] =
      AwsError.unwrapOptionField("vsam", vsam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DatasetOrgAttributes
  ) extends zio.aws.m2.model.DatasetOrgAttributes.ReadOnly {
    override val gdg: Optional[zio.aws.m2.model.GdgAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gdg())
        .map(value => zio.aws.m2.model.GdgAttributes.wrap(value))
    override val vsam: Optional[zio.aws.m2.model.VsamAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vsam())
        .map(value => zio.aws.m2.model.VsamAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DatasetOrgAttributes
  ): zio.aws.m2.model.DatasetOrgAttributes.ReadOnly = new Wrapper(impl)
}
