package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class CreateDeploymentResponse(deploymentId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateDeploymentResponse = {
    import CreateDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateDeploymentResponse
      .builder()
      .deploymentId(Identifier.unwrap(deploymentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateDeploymentResponse.ReadOnly =
    zio.aws.m2.model.CreateDeploymentResponse.wrap(buildAwsValue())
}
object CreateDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateDeploymentResponse =
      zio.aws.m2.model.CreateDeploymentResponse(deploymentId)
    def deploymentId: Identifier
    def getDeploymentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(deploymentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateDeploymentResponse
  ) extends zio.aws.m2.model.CreateDeploymentResponse.ReadOnly {
    override val deploymentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.deploymentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateDeploymentResponse
  ): zio.aws.m2.model.CreateDeploymentResponse.ReadOnly = new Wrapper(impl)
}
