package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{Timestamp, Version}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ApplicationVersionSummary(
    applicationVersion: Version,
    creationTime: Timestamp,
    status: zio.aws.m2.model.ApplicationVersionLifecycle,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ApplicationVersionSummary = {
    import ApplicationVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ApplicationVersionSummary
      .builder()
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ApplicationVersionSummary.ReadOnly =
    zio.aws.m2.model.ApplicationVersionSummary.wrap(buildAwsValue())
}
object ApplicationVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ApplicationVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ApplicationVersionSummary =
      zio.aws.m2.model.ApplicationVersionSummary(
        applicationVersion,
        creationTime,
        status,
        statusReason.map(value => value)
      )
    def applicationVersion: Version
    def creationTime: Timestamp
    def status: zio.aws.m2.model.ApplicationVersionLifecycle
    def statusReason: Optional[String]
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.m2.model.ApplicationVersionLifecycle] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ApplicationVersionSummary
  ) extends zio.aws.m2.model.ApplicationVersionSummary.ReadOnly {
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
    override val creationTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.creationTime())
    override val status: zio.aws.m2.model.ApplicationVersionLifecycle =
      zio.aws.m2.model.ApplicationVersionLifecycle.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ApplicationVersionSummary
  ): zio.aws.m2.model.ApplicationVersionSummary.ReadOnly = new Wrapper(impl)
}
