package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.Timestamp
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MaintenanceSchedule(
    endTime: Optional[Timestamp] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.MaintenanceSchedule = {
    import MaintenanceSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.MaintenanceSchedule
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.MaintenanceSchedule.ReadOnly =
    zio.aws.m2.model.MaintenanceSchedule.wrap(buildAwsValue())
}
object MaintenanceSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.MaintenanceSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.MaintenanceSchedule =
      zio.aws.m2.model.MaintenanceSchedule(
        endTime.map(value => value),
        startTime.map(value => value)
      )
    def endTime: Optional[Timestamp]
    def startTime: Optional[Timestamp]
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.MaintenanceSchedule
  ) extends zio.aws.m2.model.MaintenanceSchedule.ReadOnly {
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.MaintenanceSchedule
  ): zio.aws.m2.model.MaintenanceSchedule.ReadOnly = new Wrapper(impl)
}
