package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListDataSetsResponse(
    dataSets: Iterable[zio.aws.m2.model.DataSetSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListDataSetsResponse = {
    import ListDataSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListDataSetsResponse
      .builder()
      .dataSets(dataSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListDataSetsResponse.ReadOnly =
    zio.aws.m2.model.ListDataSetsResponse.wrap(buildAwsValue())
}
object ListDataSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListDataSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListDataSetsResponse =
      zio.aws.m2.model.ListDataSetsResponse(
        dataSets.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def dataSets: List[zio.aws.m2.model.DataSetSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDataSets
        : ZIO[Any, Nothing, List[zio.aws.m2.model.DataSetSummary.ReadOnly]] =
      ZIO.succeed(dataSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetsResponse
  ) extends zio.aws.m2.model.ListDataSetsResponse.ReadOnly {
    override val dataSets: List[zio.aws.m2.model.DataSetSummary.ReadOnly] = impl
      .dataSets()
      .asScala
      .map { item =>
        zio.aws.m2.model.DataSetSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListDataSetsResponse
  ): zio.aws.m2.model.ListDataSetsResponse.ReadOnly = new Wrapper(impl)
}
