package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{
  Identifier,
  Timestamp,
  TagValue,
  String20,
  EngineVersion,
  Arn,
  CapacityValue,
  String50,
  EntityDescription,
  EntityName,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetEnvironmentResponse(
    actualCapacity: Optional[CapacityValue] = Optional.Absent,
    creationTime: Timestamp,
    description: Optional[EntityDescription] = Optional.Absent,
    engineType: zio.aws.m2.model.EngineType,
    engineVersion: EngineVersion,
    environmentArn: Arn,
    environmentId: Identifier,
    highAvailabilityConfig: Optional[zio.aws.m2.model.HighAvailabilityConfig] =
      Optional.Absent,
    instanceType: String20,
    loadBalancerArn: Optional[String] = Optional.Absent,
    name: EntityName,
    pendingMaintenance: Optional[zio.aws.m2.model.PendingMaintenance] =
      Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    securityGroupIds: Iterable[String50],
    status: zio.aws.m2.model.EnvironmentLifecycle,
    statusReason: Optional[String] = Optional.Absent,
    storageConfigurations: Optional[
      Iterable[zio.aws.m2.model.StorageConfiguration]
    ] = Optional.Absent,
    subnetIds: Iterable[String50],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    vpcId: String50
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetEnvironmentResponse = {
    import GetEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetEnvironmentResponse
      .builder()
      .optionallyWith(
        actualCapacity.map(value => CapacityValue.unwrap(value): Integer)
      )(_.actualCapacity)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .engineType(engineType.unwrap)
      .engineVersion(EngineVersion.unwrap(engineVersion): java.lang.String)
      .environmentArn(Arn.unwrap(environmentArn): java.lang.String)
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        highAvailabilityConfig.map(value => value.buildAwsValue())
      )(_.highAvailabilityConfig)
      .instanceType(String20.unwrap(instanceType): java.lang.String)
      .optionallyWith(loadBalancerArn.map(value => value: java.lang.String))(
        _.loadBalancerArn
      )
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(pendingMaintenance.map(value => value.buildAwsValue()))(
        _.pendingMaintenance
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .securityGroupIds(securityGroupIds.map { item =>
        String50.unwrap(item): java.lang.String
      }.asJavaCollection)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        storageConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConfigurations)
      .subnetIds(subnetIds.map { item =>
        String50.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .vpcId(String50.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetEnvironmentResponse.ReadOnly =
    zio.aws.m2.model.GetEnvironmentResponse.wrap(buildAwsValue())
}
object GetEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetEnvironmentResponse =
      zio.aws.m2.model.GetEnvironmentResponse(
        actualCapacity.map(value => value),
        creationTime,
        description.map(value => value),
        engineType,
        engineVersion,
        environmentArn,
        environmentId,
        highAvailabilityConfig.map(value => value.asEditable),
        instanceType,
        loadBalancerArn.map(value => value),
        name,
        pendingMaintenance.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        securityGroupIds,
        status,
        statusReason.map(value => value),
        storageConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetIds,
        tags.map(value => value),
        vpcId
      )
    def actualCapacity: Optional[CapacityValue]
    def creationTime: Timestamp
    def description: Optional[EntityDescription]
    def engineType: zio.aws.m2.model.EngineType
    def engineVersion: EngineVersion
    def environmentArn: Arn
    def environmentId: Identifier
    def highAvailabilityConfig
        : Optional[zio.aws.m2.model.HighAvailabilityConfig.ReadOnly]
    def instanceType: String20
    def loadBalancerArn: Optional[String]
    def name: EntityName
    def pendingMaintenance
        : Optional[zio.aws.m2.model.PendingMaintenance.ReadOnly]
    def preferredMaintenanceWindow: Optional[String]
    def publiclyAccessible: Optional[Boolean]
    def securityGroupIds: List[String50]
    def status: zio.aws.m2.model.EnvironmentLifecycle
    def statusReason: Optional[String]
    def storageConfigurations
        : Optional[List[zio.aws.m2.model.StorageConfiguration.ReadOnly]]
    def subnetIds: List[String50]
    def tags: Optional[Map[TagKey, TagValue]]
    def vpcId: String50
    def getActualCapacity: ZIO[Any, AwsError, CapacityValue] =
      AwsError.unwrapOptionField("actualCapacity", actualCapacity)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEngineType: ZIO[Any, Nothing, zio.aws.m2.model.EngineType] =
      ZIO.succeed(engineType)
    def getEngineVersion: ZIO[Any, Nothing, EngineVersion] =
      ZIO.succeed(engineVersion)
    def getEnvironmentArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(environmentArn)
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
    def getHighAvailabilityConfig
        : ZIO[Any, AwsError, zio.aws.m2.model.HighAvailabilityConfig.ReadOnly] =
      AwsError.unwrapOptionField(
        "highAvailabilityConfig",
        highAvailabilityConfig
      )
    def getInstanceType: ZIO[Any, Nothing, String20] = ZIO.succeed(instanceType)
    def getLoadBalancerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getPendingMaintenance
        : ZIO[Any, AwsError, zio.aws.m2.model.PendingMaintenance.ReadOnly] =
      AwsError.unwrapOptionField("pendingMaintenance", pendingMaintenance)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[String50]] =
      ZIO.succeed(securityGroupIds)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.EnvironmentLifecycle] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getStorageConfigurations: ZIO[Any, AwsError, List[
      zio.aws.m2.model.StorageConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("storageConfigurations", storageConfigurations)
    def getSubnetIds: ZIO[Any, Nothing, List[String50]] = ZIO.succeed(subnetIds)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, Nothing, String50] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetEnvironmentResponse
  ) extends zio.aws.m2.model.GetEnvironmentResponse.ReadOnly {
    override val actualCapacity: Optional[CapacityValue] = zio.aws.core.internal
      .optionalFromNullable(impl.actualCapacity())
      .map(value => zio.aws.m2.model.primitives.CapacityValue(value))
    override val creationTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.creationTime())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.m2.model.primitives.EntityDescription(value))
    override val engineType: zio.aws.m2.model.EngineType =
      zio.aws.m2.model.EngineType.wrap(impl.engineType())
    override val engineVersion: EngineVersion =
      zio.aws.m2.model.primitives.EngineVersion(impl.engineVersion())
    override val environmentArn: Arn =
      zio.aws.m2.model.primitives.Arn(impl.environmentArn())
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
    override val highAvailabilityConfig
        : Optional[zio.aws.m2.model.HighAvailabilityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.highAvailabilityConfig())
        .map(value => zio.aws.m2.model.HighAvailabilityConfig.wrap(value))
    override val instanceType: String20 =
      zio.aws.m2.model.primitives.String20(impl.instanceType())
    override val loadBalancerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerArn())
      .map(value => value: String)
    override val name: EntityName =
      zio.aws.m2.model.primitives.EntityName(impl.name())
    override val pendingMaintenance
        : Optional[zio.aws.m2.model.PendingMaintenance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingMaintenance())
        .map(value => zio.aws.m2.model.PendingMaintenance.wrap(value))
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val securityGroupIds: List[String50] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.m2.model.primitives.String50(item)
      }
      .toList
    override val status: zio.aws.m2.model.EnvironmentLifecycle =
      zio.aws.m2.model.EnvironmentLifecycle.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val storageConfigurations
        : Optional[List[zio.aws.m2.model.StorageConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.StorageConfiguration.wrap(item)
          }.toList
        )
    override val subnetIds: List[String50] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.m2.model.primitives.String50(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.m2.model.primitives
              .TagKey(key) -> zio.aws.m2.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcId: String50 =
      zio.aws.m2.model.primitives.String50(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetEnvironmentResponse
  ): zio.aws.m2.model.GetEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
