package zio.aws.m2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.{Version, Identifier, Arn}
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationArn: Arn,
    applicationId: Identifier,
    applicationVersion: Version
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateApplicationResponse
      .builder()
      .applicationArn(Arn.unwrap(applicationArn): java.lang.String)
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateApplicationResponse.ReadOnly =
    zio.aws.m2.model.CreateApplicationResponse.wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateApplicationResponse =
      zio.aws.m2.model.CreateApplicationResponse(
        applicationArn,
        applicationId,
        applicationVersion
      )
    def applicationArn: Arn
    def applicationId: Identifier
    def applicationVersion: Version
    def getApplicationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(applicationArn)
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateApplicationResponse
  ) extends zio.aws.m2.model.CreateApplicationResponse.ReadOnly {
    override val applicationArn: Arn =
      zio.aws.m2.model.primitives.Arn(impl.applicationArn())
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateApplicationResponse
  ): zio.aws.m2.model.CreateApplicationResponse.ReadOnly = new Wrapper(impl)
}
