package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationLifecycle {
  def unwrap: software.amazon.awssdk.services.m2.model.ApplicationLifecycle
}
object ApplicationLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.ApplicationLifecycle
  ): zio.aws.m2.model.ApplicationLifecycle = value match {
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.CREATED =>
      val r = Created
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.READY =>
      val r = Ready
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.STARTING =>
      val r = Starting
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.m2.model.ApplicationLifecycle.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.CREATING
  }
  case object Created extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.CREATED
  }
  case object Available extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.AVAILABLE
  }
  case object Ready extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.READY
  }
  case object Starting extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.STARTING
  }
  case object Running extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.RUNNING
  }
  case object Stopping extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.STOPPING
  }
  case object Stopped extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.STOPPED
  }
  case object Failed extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.FAILED
  }
  case object Deleting extends zio.aws.m2.model.ApplicationLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.ApplicationLifecycle =
      software.amazon.awssdk.services.m2.model.ApplicationLifecycle.DELETING
  }
}
