package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class AlternateKey(
    allowDuplicates: Optional[Boolean] = Optional.Absent,
    length: Integer,
    name: Optional[String] = Optional.Absent,
    offset: Integer
) {
  def buildAwsValue(): software.amazon.awssdk.services.m2.model.AlternateKey = {
    import AlternateKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.AlternateKey
      .builder()
      .optionallyWith(allowDuplicates.map(value => value: java.lang.Boolean))(
        _.allowDuplicates
      )
      .length(length: java.lang.Integer)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .offset(offset: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.AlternateKey.ReadOnly =
    zio.aws.m2.model.AlternateKey.wrap(buildAwsValue())
}
object AlternateKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.AlternateKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.AlternateKey =
      zio.aws.m2.model.AlternateKey(
        allowDuplicates.map(value => value),
        length,
        name.map(value => value),
        offset
      )
    def allowDuplicates: Optional[Boolean]
    def length: Integer
    def name: Optional[String]
    def offset: Integer
    def getAllowDuplicates: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowDuplicates", allowDuplicates)
    def getLength: ZIO[Any, Nothing, Integer] = ZIO.succeed(length)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getOffset: ZIO[Any, Nothing, Integer] = ZIO.succeed(offset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.AlternateKey
  ) extends zio.aws.m2.model.AlternateKey.ReadOnly {
    override val allowDuplicates: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowDuplicates())
      .map(value => value: Boolean)
    override val length: Integer = impl.length(): Integer
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val offset: Integer = impl.offset(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.AlternateKey
  ): zio.aws.m2.model.AlternateKey.ReadOnly = new Wrapper(impl)
}
