package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{
  String100,
  NextToken,
  Identifier,
  Timestamp,
  MaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBatchJobExecutionsRequest(
    applicationId: Identifier,
    executionIds: Optional[Iterable[Identifier]] = Optional.Absent,
    jobName: Optional[String100] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    startedAfter: Optional[Timestamp] = Optional.Absent,
    startedBefore: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.m2.model.BatchJobExecutionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest = {
    import ListBatchJobExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        executionIds.map(value =>
          value.map { item =>
            Identifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.executionIds)
      .optionallyWith(
        jobName.map(value => String100.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        startedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.startedAfter)
      .optionallyWith(
        startedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.startedBefore)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListBatchJobExecutionsRequest.ReadOnly =
    zio.aws.m2.model.ListBatchJobExecutionsRequest.wrap(buildAwsValue())
}
object ListBatchJobExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListBatchJobExecutionsRequest =
      zio.aws.m2.model.ListBatchJobExecutionsRequest(
        applicationId,
        executionIds.map(value => value),
        jobName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        startedAfter.map(value => value),
        startedBefore.map(value => value),
        status.map(value => value)
      )
    def applicationId: Identifier
    def executionIds: Optional[List[Identifier]]
    def jobName: Optional[String100]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def startedAfter: Optional[Timestamp]
    def startedBefore: Optional[Timestamp]
    def status: Optional[zio.aws.m2.model.BatchJobExecutionStatus]
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getExecutionIds: ZIO[Any, AwsError, List[Identifier]] =
      AwsError.unwrapOptionField("executionIds", executionIds)
    def getJobName: ZIO[Any, AwsError, String100] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAfter", startedAfter)
    def getStartedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedBefore", startedBefore)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.m2.model.BatchJobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest
  ) extends zio.aws.m2.model.ListBatchJobExecutionsRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val executionIds: Optional[List[Identifier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.primitives.Identifier(item)
          }.toList
        )
    override val jobName: Optional[String100] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.m2.model.primitives.String100(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.m2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
    override val startedAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAfter())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val startedBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBefore())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.m2.model.BatchJobExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.m2.model.BatchJobExecutionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest
  ): zio.aws.m2.model.ListBatchJobExecutionsRequest.ReadOnly = new Wrapper(impl)
}
