package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListApplicationVersionsResponse(
    applicationVersions: Iterable[zio.aws.m2.model.ApplicationVersionSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse = {
    import ListApplicationVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse
      .builder()
      .applicationVersions(applicationVersions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly =
    zio.aws.m2.model.ListApplicationVersionsResponse.wrap(buildAwsValue())
}
object ListApplicationVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.ListApplicationVersionsResponse =
      zio.aws.m2.model.ListApplicationVersionsResponse(
        applicationVersions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def applicationVersions
        : List[zio.aws.m2.model.ApplicationVersionSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getApplicationVersions: ZIO[Any, Nothing, List[
      zio.aws.m2.model.ApplicationVersionSummary.ReadOnly
    ]] = ZIO.succeed(applicationVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse
  ) extends zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly {
    override val applicationVersions
        : List[zio.aws.m2.model.ApplicationVersionSummary.ReadOnly] = impl
      .applicationVersions()
      .asScala
      .map { item =>
        zio.aws.m2.model.ApplicationVersionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.m2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse
  ): zio.aws.m2.model.ListApplicationVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
