package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{
  Timestamp,
  Version,
  EntityDescription,
  StringFree65000,
  EntityName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetApplicationVersionResponse(
    applicationVersion: Version,
    creationTime: Timestamp,
    definitionContent: StringFree65000,
    description: Optional[EntityDescription] = Optional.Absent,
    name: EntityName,
    status: zio.aws.m2.model.ApplicationVersionLifecycle,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetApplicationVersionResponse = {
    import GetApplicationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetApplicationVersionResponse
      .builder()
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .definitionContent(
        StringFree65000.unwrap(definitionContent): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(EntityName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly =
    zio.aws.m2.model.GetApplicationVersionResponse.wrap(buildAwsValue())
}
object GetApplicationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetApplicationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetApplicationVersionResponse =
      zio.aws.m2.model.GetApplicationVersionResponse(
        applicationVersion,
        creationTime,
        definitionContent,
        description.map(value => value),
        name,
        status,
        statusReason.map(value => value)
      )
    def applicationVersion: Version
    def creationTime: Timestamp
    def definitionContent: StringFree65000
    def description: Optional[EntityDescription]
    def name: EntityName
    def status: zio.aws.m2.model.ApplicationVersionLifecycle
    def statusReason: Optional[String]
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDefinitionContent: ZIO[Any, Nothing, StringFree65000] =
      ZIO.succeed(definitionContent)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.m2.model.ApplicationVersionLifecycle] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationVersionResponse
  ) extends zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly {
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
    override val creationTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.creationTime())
    override val definitionContent: StringFree65000 =
      zio.aws.m2.model.primitives.StringFree65000(impl.definitionContent())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.m2.model.primitives.EntityDescription(value))
    override val name: EntityName =
      zio.aws.m2.model.primitives.EntityName(impl.name())
    override val status: zio.aws.m2.model.ApplicationVersionLifecycle =
      zio.aws.m2.model.ApplicationVersionLifecycle.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationVersionResponse
  ): zio.aws.m2.model.GetApplicationVersionResponse.ReadOnly = new Wrapper(impl)
}
