package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class GetApplicationRequest(applicationId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.GetApplicationRequest = {
    import GetApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.GetApplicationRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.GetApplicationRequest.ReadOnly =
    zio.aws.m2.model.GetApplicationRequest.wrap(buildAwsValue())
}
object GetApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.GetApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.GetApplicationRequest =
      zio.aws.m2.model.GetApplicationRequest(applicationId)
    def applicationId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationRequest
  ) extends zio.aws.m2.model.GetApplicationRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.GetApplicationRequest
  ): zio.aws.m2.model.GetApplicationRequest.ReadOnly = new Wrapper(impl)
}
