package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.String200
import scala.jdk.CollectionConverters._
final case class EfsStorageConfiguration(
    fileSystemId: String200,
    mountPoint: String200
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.EfsStorageConfiguration = {
    import EfsStorageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.EfsStorageConfiguration
      .builder()
      .fileSystemId(String200.unwrap(fileSystemId): java.lang.String)
      .mountPoint(String200.unwrap(mountPoint): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.EfsStorageConfiguration.ReadOnly =
    zio.aws.m2.model.EfsStorageConfiguration.wrap(buildAwsValue())
}
object EfsStorageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.EfsStorageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.EfsStorageConfiguration =
      zio.aws.m2.model.EfsStorageConfiguration(fileSystemId, mountPoint)
    def fileSystemId: String200
    def mountPoint: String200
    def getFileSystemId: ZIO[Any, Nothing, String200] =
      ZIO.succeed(fileSystemId)
    def getMountPoint: ZIO[Any, Nothing, String200] = ZIO.succeed(mountPoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.EfsStorageConfiguration
  ) extends zio.aws.m2.model.EfsStorageConfiguration.ReadOnly {
    override val fileSystemId: String200 =
      zio.aws.m2.model.primitives.String200(impl.fileSystemId())
    override val mountPoint: String200 =
      zio.aws.m2.model.primitives.String200(impl.mountPoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.EfsStorageConfiguration
  ): zio.aws.m2.model.EfsStorageConfiguration.ReadOnly = new Wrapper(impl)
}
