package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class DeleteApplicationFromEnvironmentRequest(
    applicationId: Identifier,
    environmentId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DeleteApplicationFromEnvironmentRequest = {
    import DeleteApplicationFromEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DeleteApplicationFromEnvironmentRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest.ReadOnly =
    zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationFromEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DeleteApplicationFromEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest =
      zio.aws.m2.model
        .DeleteApplicationFromEnvironmentRequest(applicationId, environmentId)
    def applicationId: Identifier
    def environmentId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DeleteApplicationFromEnvironmentRequest
  ) extends zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DeleteApplicationFromEnvironmentRequest
  ): zio.aws.m2.model.DeleteApplicationFromEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
