package zio.aws.m2.model
import scala.jdk.CollectionConverters._
sealed trait DataSetTaskLifecycle {
  def unwrap: software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle
}
object DataSetTaskLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle
  ): zio.aws.m2.model.DataSetTaskLifecycle = value match {
    case software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.COMPLETED =>
      val r = Completed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.m2.model.DataSetTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle =
      software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.m2.model.DataSetTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle =
      software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.CREATING
  }
  case object Running extends zio.aws.m2.model.DataSetTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle =
      software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.RUNNING
  }
  case object Completed extends zio.aws.m2.model.DataSetTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle =
      software.amazon.awssdk.services.m2.model.DataSetTaskLifecycle.COMPLETED
  }
}
