package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{String20, String200, Timestamp}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DataSetSummary(
    creationTime: Optional[Timestamp] = Optional.Absent,
    dataSetName: String200,
    dataSetOrg: Optional[String20] = Optional.Absent,
    format: Optional[String20] = Optional.Absent,
    lastReferencedTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DataSetSummary = {
    import DataSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DataSetSummary
      .builder()
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .dataSetName(String200.unwrap(dataSetName): java.lang.String)
      .optionallyWith(
        dataSetOrg.map(value => String20.unwrap(value): java.lang.String)
      )(_.dataSetOrg)
      .optionallyWith(
        format.map(value => String20.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        lastReferencedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastReferencedTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DataSetSummary.ReadOnly =
    zio.aws.m2.model.DataSetSummary.wrap(buildAwsValue())
}
object DataSetSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.m2.model.DataSetSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DataSetSummary =
      zio.aws.m2.model.DataSetSummary(
        creationTime.map(value => value),
        dataSetName,
        dataSetOrg.map(value => value),
        format.map(value => value),
        lastReferencedTime.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def creationTime: Optional[Timestamp]
    def dataSetName: String200
    def dataSetOrg: Optional[String20]
    def format: Optional[String20]
    def lastReferencedTime: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDataSetName: ZIO[Any, Nothing, String200] = ZIO.succeed(dataSetName)
    def getDataSetOrg: ZIO[Any, AwsError, String20] =
      AwsError.unwrapOptionField("dataSetOrg", dataSetOrg)
    def getFormat: ZIO[Any, AwsError, String20] =
      AwsError.unwrapOptionField("format", format)
    def getLastReferencedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastReferencedTime", lastReferencedTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DataSetSummary
  ) extends zio.aws.m2.model.DataSetSummary.ReadOnly {
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val dataSetName: String200 =
      zio.aws.m2.model.primitives.String200(impl.dataSetName())
    override val dataSetOrg: Optional[String20] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSetOrg())
      .map(value => zio.aws.m2.model.primitives.String20(value))
    override val format: Optional[String20] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.m2.model.primitives.String20(value))
    override val lastReferencedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastReferencedTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DataSetSummary
  ): zio.aws.m2.model.DataSetSummary.ReadOnly = new Wrapper(impl)
}
