package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class DataSetImportSummary(
    failed: Integer,
    inProgress: Integer,
    pending: Integer,
    succeeded: Integer,
    total: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.DataSetImportSummary = {
    import DataSetImportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.DataSetImportSummary
      .builder()
      .failed(failed: java.lang.Integer)
      .inProgress(inProgress: java.lang.Integer)
      .pending(pending: java.lang.Integer)
      .succeeded(succeeded: java.lang.Integer)
      .total(total: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.DataSetImportSummary.ReadOnly =
    zio.aws.m2.model.DataSetImportSummary.wrap(buildAwsValue())
}
object DataSetImportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.DataSetImportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.DataSetImportSummary = zio.aws.m2.model
      .DataSetImportSummary(failed, inProgress, pending, succeeded, total)
    def failed: Integer
    def inProgress: Integer
    def pending: Integer
    def succeeded: Integer
    def total: Integer
    def getFailed: ZIO[Any, Nothing, Integer] = ZIO.succeed(failed)
    def getInProgress: ZIO[Any, Nothing, Integer] = ZIO.succeed(inProgress)
    def getPending: ZIO[Any, Nothing, Integer] = ZIO.succeed(pending)
    def getSucceeded: ZIO[Any, Nothing, Integer] = ZIO.succeed(succeeded)
    def getTotal: ZIO[Any, Nothing, Integer] = ZIO.succeed(total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportSummary
  ) extends zio.aws.m2.model.DataSetImportSummary.ReadOnly {
    override val failed: Integer = impl.failed(): Integer
    override val inProgress: Integer = impl.inProgress(): Integer
    override val pending: Integer = impl.pending(): Integer
    override val succeeded: Integer = impl.succeeded(): Integer
    override val total: Integer = impl.total(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.DataSetImportSummary
  ): zio.aws.m2.model.DataSetImportSummary.ReadOnly = new Wrapper(impl)
}
