package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentResponse(environmentId: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateEnvironmentResponse = {
    import CreateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateEnvironmentResponse
      .builder()
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly =
    zio.aws.m2.model.CreateEnvironmentResponse.wrap(buildAwsValue())
}
object CreateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateEnvironmentResponse =
      zio.aws.m2.model.CreateEnvironmentResponse(environmentId)
    def environmentId: Identifier
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateEnvironmentResponse
  ) extends zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly {
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateEnvironmentResponse
  ): zio.aws.m2.model.CreateEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
