package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.m2.model.primitives.{
  TagValue,
  String20,
  EngineVersion,
  String50,
  EntityDescription,
  EntityName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentRequest(
    clientToken: Optional[String] = Optional.Absent,
    description: Optional[EntityDescription] = Optional.Absent,
    engineType: zio.aws.m2.model.EngineType,
    engineVersion: Optional[EngineVersion] = Optional.Absent,
    highAvailabilityConfig: Optional[zio.aws.m2.model.HighAvailabilityConfig] =
      Optional.Absent,
    instanceType: String20,
    name: EntityName,
    preferredMaintenanceWindow: Optional[String50] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String50]] = Optional.Absent,
    storageConfigurations: Optional[
      Iterable[zio.aws.m2.model.StorageConfiguration]
    ] = Optional.Absent,
    subnetIds: Optional[Iterable[String50]] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateEnvironmentRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .engineType(engineType.unwrap)
      .optionallyWith(
        engineVersion.map(value =>
          EngineVersion.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        highAvailabilityConfig.map(value => value.buildAwsValue())
      )(_.highAvailabilityConfig)
      .instanceType(String20.unwrap(instanceType): java.lang.String)
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          String50.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            String50.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        storageConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConfigurations)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            String50.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.m2.model.CreateEnvironmentRequest.wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateEnvironmentRequest =
      zio.aws.m2.model.CreateEnvironmentRequest(
        clientToken.map(value => value),
        description.map(value => value),
        engineType,
        engineVersion.map(value => value),
        highAvailabilityConfig.map(value => value.asEditable),
        instanceType,
        name,
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        securityGroupIds.map(value => value),
        storageConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetIds.map(value => value),
        tags.map(value => value)
      )
    def clientToken: Optional[String]
    def description: Optional[EntityDescription]
    def engineType: zio.aws.m2.model.EngineType
    def engineVersion: Optional[EngineVersion]
    def highAvailabilityConfig
        : Optional[zio.aws.m2.model.HighAvailabilityConfig.ReadOnly]
    def instanceType: String20
    def name: EntityName
    def preferredMaintenanceWindow: Optional[String50]
    def publiclyAccessible: Optional[Boolean]
    def securityGroupIds: Optional[List[String50]]
    def storageConfigurations
        : Optional[List[zio.aws.m2.model.StorageConfiguration.ReadOnly]]
    def subnetIds: Optional[List[String50]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEngineType: ZIO[Any, Nothing, zio.aws.m2.model.EngineType] =
      ZIO.succeed(engineType)
    def getEngineVersion: ZIO[Any, AwsError, EngineVersion] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getHighAvailabilityConfig
        : ZIO[Any, AwsError, zio.aws.m2.model.HighAvailabilityConfig.ReadOnly] =
      AwsError.unwrapOptionField(
        "highAvailabilityConfig",
        highAvailabilityConfig
      )
    def getInstanceType: ZIO[Any, Nothing, String20] = ZIO.succeed(instanceType)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String50] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String50]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getStorageConfigurations: ZIO[Any, AwsError, List[
      zio.aws.m2.model.StorageConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("storageConfigurations", storageConfigurations)
    def getSubnetIds: ZIO[Any, AwsError, List[String50]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateEnvironmentRequest
  ) extends zio.aws.m2.model.CreateEnvironmentRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.m2.model.primitives.EntityDescription(value))
    override val engineType: zio.aws.m2.model.EngineType =
      zio.aws.m2.model.EngineType.wrap(impl.engineType())
    override val engineVersion: Optional[EngineVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.m2.model.primitives.EngineVersion(value))
    override val highAvailabilityConfig
        : Optional[zio.aws.m2.model.HighAvailabilityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.highAvailabilityConfig())
        .map(value => zio.aws.m2.model.HighAvailabilityConfig.wrap(value))
    override val instanceType: String20 =
      zio.aws.m2.model.primitives.String20(impl.instanceType())
    override val name: EntityName =
      zio.aws.m2.model.primitives.EntityName(impl.name())
    override val preferredMaintenanceWindow: Optional[String50] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => zio.aws.m2.model.primitives.String50(value))
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val securityGroupIds: Optional[List[String50]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.primitives.String50(item)
          }.toList
        )
    override val storageConfigurations
        : Optional[List[zio.aws.m2.model.StorageConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.m2.model.StorageConfiguration.wrap(item)
          }.toList
        )
    override val subnetIds: Optional[List[String50]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.m2.model.primitives.String50(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.m2.model.primitives
              .TagKey(key) -> zio.aws.m2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateEnvironmentRequest
  ): zio.aws.m2.model.CreateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
