package zio.aws.m2.model
import zio.aws.m2.model.primitives.{Version, Identifier}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateDeploymentRequest(
    applicationId: Identifier,
    applicationVersion: Version,
    clientToken: Optional[String] = Optional.Absent,
    environmentId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CreateDeploymentRequest = {
    import CreateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CreateDeploymentRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .applicationVersion(Version.unwrap(applicationVersion): Integer)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .environmentId(Identifier.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CreateDeploymentRequest.ReadOnly =
    zio.aws.m2.model.CreateDeploymentRequest.wrap(buildAwsValue())
}
object CreateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CreateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CreateDeploymentRequest =
      zio.aws.m2.model.CreateDeploymentRequest(
        applicationId,
        applicationVersion,
        clientToken.map(value => value),
        environmentId
      )
    def applicationId: Identifier
    def applicationVersion: Version
    def clientToken: Optional[String]
    def environmentId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getApplicationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(applicationVersion)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CreateDeploymentRequest
  ) extends zio.aws.m2.model.CreateDeploymentRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val applicationVersion: Version =
      zio.aws.m2.model.primitives.Version(impl.applicationVersion())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val environmentId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CreateDeploymentRequest
  ): zio.aws.m2.model.CreateDeploymentRequest.ReadOnly = new Wrapper(impl)
}
