package zio.aws.m2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.m2.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class CancelBatchJobExecutionRequest(
    applicationId: Identifier,
    executionId: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.CancelBatchJobExecutionRequest = {
    import CancelBatchJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.CancelBatchJobExecutionRequest
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .executionId(Identifier.unwrap(executionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.CancelBatchJobExecutionRequest.ReadOnly =
    zio.aws.m2.model.CancelBatchJobExecutionRequest.wrap(buildAwsValue())
}
object CancelBatchJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.CancelBatchJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.CancelBatchJobExecutionRequest =
      zio.aws.m2.model
        .CancelBatchJobExecutionRequest(applicationId, executionId)
    def applicationId: Identifier
    def executionId: Identifier
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getExecutionId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(executionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.CancelBatchJobExecutionRequest
  ) extends zio.aws.m2.model.CancelBatchJobExecutionRequest.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val executionId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.executionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.CancelBatchJobExecutionRequest
  ): zio.aws.m2.model.CancelBatchJobExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
