package zio.aws.m2.model
import java.time.Instant
import zio.aws.m2.model.primitives.{String100, Timestamp, Identifier}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class BatchJobExecutionSummary(
    applicationId: Identifier,
    endTime: Optional[Timestamp] = Optional.Absent,
    executionId: Identifier,
    jobId: Optional[String100] = Optional.Absent,
    jobName: Optional[String100] = Optional.Absent,
    jobType: Optional[zio.aws.m2.model.BatchJobType] = Optional.Absent,
    startTime: Timestamp,
    status: zio.aws.m2.model.BatchJobExecutionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary = {
    import BatchJobExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary
      .builder()
      .applicationId(Identifier.unwrap(applicationId): java.lang.String)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .executionId(Identifier.unwrap(executionId): java.lang.String)
      .optionallyWith(
        jobId.map(value => String100.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobName.map(value => String100.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly =
    zio.aws.m2.model.BatchJobExecutionSummary.wrap(buildAwsValue())
}
object BatchJobExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.m2.model.BatchJobExecutionSummary =
      zio.aws.m2.model.BatchJobExecutionSummary(
        applicationId,
        endTime.map(value => value),
        executionId,
        jobId.map(value => value),
        jobName.map(value => value),
        jobType.map(value => value),
        startTime,
        status
      )
    def applicationId: Identifier
    def endTime: Optional[Timestamp]
    def executionId: Identifier
    def jobId: Optional[String100]
    def jobName: Optional[String100]
    def jobType: Optional[zio.aws.m2.model.BatchJobType]
    def startTime: Timestamp
    def status: zio.aws.m2.model.BatchJobExecutionStatus
    def getApplicationId: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationId)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getExecutionId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(executionId)
    def getJobId: ZIO[Any, AwsError, String100] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobName: ZIO[Any, AwsError, String100] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobType: ZIO[Any, AwsError, zio.aws.m2.model.BatchJobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.m2.model.BatchJobExecutionStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary
  ) extends zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly {
    override val applicationId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.applicationId())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.m2.model.primitives.Timestamp(value))
    override val executionId: Identifier =
      zio.aws.m2.model.primitives.Identifier(impl.executionId())
    override val jobId: Optional[String100] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.m2.model.primitives.String100(value))
    override val jobName: Optional[String100] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.m2.model.primitives.String100(value))
    override val jobType: Optional[zio.aws.m2.model.BatchJobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.m2.model.BatchJobType.wrap(value))
    override val startTime: Timestamp =
      zio.aws.m2.model.primitives.Timestamp(impl.startTime())
    override val status: zio.aws.m2.model.BatchJobExecutionStatus =
      zio.aws.m2.model.BatchJobExecutionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary
  ): zio.aws.m2.model.BatchJobExecutionSummary.ReadOnly = new Wrapper(impl)
}
