package zio.aws.lookoutvision.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.lookoutvision.model.primitives.{
  DateTime,
  ProjectName,
  ProjectArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProjectMetadata(
    projectArn: Optional[ProjectArn] = Optional.Absent,
    projectName: Optional[ProjectName] = Optional.Absent,
    creationTimestamp: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ProjectMetadata = {
    import ProjectMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ProjectMetadata
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly =
    zio.aws.lookoutvision.model.ProjectMetadata.wrap(buildAwsValue())
}
object ProjectMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ProjectMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ProjectMetadata =
      zio.aws.lookoutvision.model.ProjectMetadata(
        projectArn.map(value => value),
        projectName.map(value => value),
        creationTimestamp.map(value => value)
      )
    def projectArn: Optional[ProjectArn]
    def projectName: Optional[ProjectName]
    def creationTimestamp: Optional[DateTime]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ProjectMetadata
  ) extends zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly {
    override val projectArn: Optional[ProjectArn] = zio.aws.core.internal
      .optionalFromNullable(impl.projectArn())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectArn(value))
    override val projectName: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectName(value))
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ProjectMetadata
  ): zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly = new Wrapper(impl)
}
