package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModelPackagingConfiguration(
    greengrass: zio.aws.lookoutvision.model.GreengrassConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingConfiguration = {
    import ModelPackagingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingConfiguration
      .builder()
      .greengrass(greengrass.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly =
    zio.aws.lookoutvision.model.ModelPackagingConfiguration
      .wrap(buildAwsValue())
}
object ModelPackagingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelPackagingConfiguration =
      zio.aws.lookoutvision.model
        .ModelPackagingConfiguration(greengrass.asEditable)
    def greengrass: zio.aws.lookoutvision.model.GreengrassConfiguration.ReadOnly
    def getGreengrass: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutvision.model.GreengrassConfiguration.ReadOnly
    ] = ZIO.succeed(greengrass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingConfiguration
  ) extends zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly {
    override val greengrass
        : zio.aws.lookoutvision.model.GreengrassConfiguration.ReadOnly =
      zio.aws.lookoutvision.model.GreengrassConfiguration
        .wrap(impl.greengrass())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingConfiguration
  ): zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly =
    new Wrapper(impl)
}
