package zio.aws.lookoutvision.model
import zio.prelude.data.Optional
import zio.aws.lookoutvision.model.primitives.{
  PageSize,
  PaginationToken,
  ProjectName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListModelPackagingJobsRequest(
    projectName: ProjectName,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest = {
    import ListModelPackagingJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ListModelPackagingJobsRequest.ReadOnly =
    zio.aws.lookoutvision.model.ListModelPackagingJobsRequest
      .wrap(buildAwsValue())
}
object ListModelPackagingJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListModelPackagingJobsRequest =
      zio.aws.lookoutvision.model.ListModelPackagingJobsRequest(
        projectName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectName: ProjectName
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PageSize]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest
  ) extends zio.aws.lookoutvision.model.ListModelPackagingJobsRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutvision.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest
  ): zio.aws.lookoutvision.model.ListModelPackagingJobsRequest.ReadOnly =
    new Wrapper(impl)
}
