package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.AnomalyMask
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectAnomalyResult(
    source: Optional[zio.aws.lookoutvision.model.ImageSource] = Optional.Absent,
    isAnomalous: Optional[Boolean] = Optional.Absent,
    confidence: Optional[Float] = Optional.Absent,
    anomalies: Optional[Iterable[zio.aws.lookoutvision.model.Anomaly]] =
      Optional.Absent,
    anomalyMask: Optional[AnomalyMask] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult = {
    import DetectAnomalyResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(isAnomalous.map(value => value: java.lang.Boolean))(
        _.isAnomalous
      )
      .optionallyWith(confidence.map(value => value: java.lang.Float))(
        _.confidence
      )
      .optionallyWith(
        anomalies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.anomalies)
      .optionallyWith(
        anomalyMask.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.anomalyMask)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly =
    zio.aws.lookoutvision.model.DetectAnomalyResult.wrap(buildAwsValue())
}
object DetectAnomalyResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DetectAnomalyResult =
      zio.aws.lookoutvision.model.DetectAnomalyResult(
        source.map(value => value.asEditable),
        isAnomalous.map(value => value),
        confidence.map(value => value),
        anomalies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        anomalyMask.map(value => value)
      )
    def source: Optional[zio.aws.lookoutvision.model.ImageSource.ReadOnly]
    def isAnomalous: Optional[Boolean]
    def confidence: Optional[Float]
    def anomalies: Optional[List[zio.aws.lookoutvision.model.Anomaly.ReadOnly]]
    def anomalyMask: Optional[AnomalyMask]
    def getSource
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.ImageSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getIsAnomalous: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAnomalous", isAnomalous)
    def getConfidence: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getAnomalies: ZIO[Any, AwsError, List[
      zio.aws.lookoutvision.model.Anomaly.ReadOnly
    ]] = AwsError.unwrapOptionField("anomalies", anomalies)
    def getAnomalyMask: ZIO[Any, AwsError, AnomalyMask] =
      AwsError.unwrapOptionField("anomalyMask", anomalyMask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
  ) extends zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly {
    override val source
        : Optional[zio.aws.lookoutvision.model.ImageSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.lookoutvision.model.ImageSource.wrap(value))
    override val isAnomalous: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAnomalous())
      .map(value => value: Boolean)
    override val confidence: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => value: Float)
    override val anomalies
        : Optional[List[zio.aws.lookoutvision.model.Anomaly.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.Anomaly.wrap(item)
          }.toList
        )
    override val anomalyMask: Optional[AnomalyMask] = zio.aws.core.internal
      .optionalFromNullable(impl.anomalyMask())
      .map(value =>
        zio.aws.lookoutvision.model.primitives
          .AnomalyMask(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
  ): zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly = new Wrapper(
    impl
  )
}
