package zio.aws.lookoutvision.model
import zio.prelude.data.Optional
import zio.aws.lookoutvision.model.primitives.{
  ClientToken,
  InferenceUnits,
  ModelVersion,
  ProjectName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartModelRequest(
    projectName: ProjectName,
    modelVersion: ModelVersion,
    minInferenceUnits: InferenceUnits,
    clientToken: Optional[ClientToken] = Optional.Absent,
    maxInferenceUnits: Optional[InferenceUnits] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.StartModelRequest = {
    import StartModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.StartModelRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .modelVersion(ModelVersion.unwrap(modelVersion): java.lang.String)
      .minInferenceUnits(InferenceUnits.unwrap(minInferenceUnits): Integer)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        maxInferenceUnits.map(value => InferenceUnits.unwrap(value): Integer)
      )(_.maxInferenceUnits)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.StartModelRequest.ReadOnly =
    zio.aws.lookoutvision.model.StartModelRequest.wrap(buildAwsValue())
}
object StartModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.StartModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.StartModelRequest =
      zio.aws.lookoutvision.model.StartModelRequest(
        projectName,
        modelVersion,
        minInferenceUnits,
        clientToken.map(value => value),
        maxInferenceUnits.map(value => value)
      )
    def projectName: ProjectName
    def modelVersion: ModelVersion
    def minInferenceUnits: InferenceUnits
    def clientToken: Optional[ClientToken]
    def maxInferenceUnits: Optional[InferenceUnits]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersion] =
      ZIO.succeed(modelVersion)
    def getMinInferenceUnits: ZIO[Any, Nothing, InferenceUnits] =
      ZIO.succeed(minInferenceUnits)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMaxInferenceUnits: ZIO[Any, AwsError, InferenceUnits] =
      AwsError.unwrapOptionField("maxInferenceUnits", maxInferenceUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelRequest
  ) extends zio.aws.lookoutvision.model.StartModelRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val modelVersion: ModelVersion =
      zio.aws.lookoutvision.model.primitives.ModelVersion(impl.modelVersion())
    override val minInferenceUnits: InferenceUnits =
      zio.aws.lookoutvision.model.primitives
        .InferenceUnits(impl.minInferenceUnits())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
    override val maxInferenceUnits: Optional[InferenceUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxInferenceUnits())
        .map(value =>
          zio.aws.lookoutvision.model.primitives.InferenceUnits(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelRequest
  ): zio.aws.lookoutvision.model.StartModelRequest.ReadOnly = new Wrapper(impl)
}
