package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeModelPackagingJobResponse(
    modelPackagingDescription: Optional[
      zio.aws.lookoutvision.model.ModelPackagingDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse = {
    import DescribeModelPackagingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse
      .builder()
      .optionallyWith(
        modelPackagingDescription.map(value => value.buildAwsValue())
      )(_.modelPackagingDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly =
    zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse
      .wrap(buildAwsValue())
}
object DescribeModelPackagingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse =
      zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse(
        modelPackagingDescription.map(value => value.asEditable)
      )
    def modelPackagingDescription: Optional[
      zio.aws.lookoutvision.model.ModelPackagingDescription.ReadOnly
    ]
    def getModelPackagingDescription: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPackagingDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelPackagingDescription",
      modelPackagingDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse
  ) extends zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly {
    override val modelPackagingDescription: Optional[
      zio.aws.lookoutvision.model.ModelPackagingDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelPackagingDescription())
      .map(value =>
        zio.aws.lookoutvision.model.ModelPackagingDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobResponse
  ): zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly =
    new Wrapper(impl)
}
