package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.ProjectArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteProjectResponse(
    projectArn: Optional[ProjectArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse = {
    import DeleteProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly =
    zio.aws.lookoutvision.model.DeleteProjectResponse.wrap(buildAwsValue())
}
object DeleteProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DeleteProjectResponse =
      zio.aws.lookoutvision.model
        .DeleteProjectResponse(projectArn.map(value => value))
    def projectArn: Optional[ProjectArn]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse
  ) extends zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly {
    override val projectArn: Optional[ProjectArn] = zio.aws.core.internal
      .optionalFromNullable(impl.projectArn())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteProjectResponse
  ): zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
