package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ClientToken,
  ModelVersion,
  ProjectName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopModelRequest(
    projectName: ProjectName,
    modelVersion: ModelVersion,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.StopModelRequest = {
    import StopModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.StopModelRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .modelVersion(ModelVersion.unwrap(modelVersion): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.StopModelRequest.ReadOnly =
    zio.aws.lookoutvision.model.StopModelRequest.wrap(buildAwsValue())
}
object StopModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.StopModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.StopModelRequest =
      zio.aws.lookoutvision.model.StopModelRequest(
        projectName,
        modelVersion,
        clientToken.map(value => value)
      )
    def projectName: ProjectName
    def modelVersion: ModelVersion
    def clientToken: Optional[ClientToken]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersion] =
      ZIO.succeed(modelVersion)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.StopModelRequest
  ) extends zio.aws.lookoutvision.model.StopModelRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val modelVersion: ModelVersion =
      zio.aws.lookoutvision.model.primitives.ModelVersion(impl.modelVersion())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.StopModelRequest
  ): zio.aws.lookoutvision.model.StopModelRequest.ReadOnly = new Wrapper(impl)
}
