package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait TargetDevice {
  def unwrap: software.amazon.awssdk.services.lookoutvision.model.TargetDevice
}
object TargetDevice {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.TargetDevice
  ): zio.aws.lookoutvision.model.TargetDevice = value match {
    case software.amazon.awssdk.services.lookoutvision.model.TargetDevice.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.TargetDevice.JETSON_XAVIER =>
      val r = jetson_xavier
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetDevice =
      software.amazon.awssdk.services.lookoutvision.model.TargetDevice.UNKNOWN_TO_SDK_VERSION
  }
  case object jetson_xavier extends zio.aws.lookoutvision.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetDevice =
      software.amazon.awssdk.services.lookoutvision.model.TargetDevice.JETSON_XAVIER
  }
}
